<?php
session_start();
$apiKey = "AIzaSyDUbCg_mHy0sLnCrQ9RL_t2ND9TbVPd85A"; 

function analyzeCustomer($text, $apiKey) {
    $url = "https://generativelanguage.googleapis.com/v1beta/models/gemini-2.0-flash:generateContent";
    $data = [
        "contents" => [
            ["parts"=>[["text"=>"حلل هذا النص للعميل وأخبرني عن التزامه، اتجاه الطلبات، المخاطر، وتوصيات: $text"]]]
        ]
    ];

    $ch = curl_init($url);
    curl_setopt($ch, CURLOPT_HTTPHEADER, [
        "Content-Type: application/json",
        "X-goog-api-key: $apiKey"
    ]);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_TIMEOUT, 60);
    $response = curl_exec($ch);
    curl_close($ch);

    $res = json_decode($response,true);
    return $res['candidates'][0]['content']['parts'][0]['text'] ?? 'لا يوجد تحليل متاح';
}

$client = $_POST['client'] ?? '';
$allClients = $_SESSION['clients'] ?? [];
$movements = $allClients[$client] ?? [];

if(empty($movements)){
    echo "❌ لا توجد حركات لهذا العميل.";
    exit;
}

$text = "";
foreach($movements as $m){
    $date = $m['date'] ?: '';
    $desc = $m['desc'] ?: '';
    $debit = $m['debit'] ?: '';
    $credit = $m['credit'] ?: '';
    $text .= "التاريخ: $date, البيان: $desc, مدين: $debit, دائن: $credit\n";
}

echo analyzeCustomer($text, $apiKey);
