<?php
session_start();
ini_set('display_errors',1);
ini_set('display_startup_errors',1);
error_reporting(E_ALL);

require __DIR__ . '/vendor/autoload.php';
use PhpOffice\PhpSpreadsheet\IOFactory;

function safeTrim($val){ return isset($val) ? trim($val) : ''; }

$clients = [];
$warnings = [];
$headers = [];

if($_SERVER['REQUEST_METHOD']==='POST' && isset($_FILES['excel_file'])){
    $filePath = $_FILES['excel_file']['tmp_name'];

    try {
        $spreadsheet = IOFactory::load($filePath);
        $sheet = $spreadsheet->getActiveSheet();
        $rows = $sheet->toArray(null,true,true,true);

        $rows = array_filter($rows,function($r){ foreach($r as $c) if(safeTrim($c)!='') return true; return false; });
        if(empty($rows)) die("<div class='alert alert-danger'>❌ الملف فارغ.</div>");

        $headerRow = array_shift($rows);
        $headers = array_map('safeTrim',$headerRow);

        echo "<div class='alert alert-info'><strong>الأعمدة الموجودة:</strong> ".implode(", ", $headers)."</div>";

        $columns_map = ['التاريخ'=>'','البيان'=>'','مدين'=>'','دائن'=>''];
        foreach($headers as $col=>$h){
            $h_clean = mb_strtolower(str_replace(' ','',$h));
            if(str_contains($h_clean,'تاريخ')) $columns_map['التاريخ']=$col;
            if(str_contains($h_clean,'بيان'))  $columns_map['البيان']=$col;
            if(str_contains($h_clean,'مدين'))  $columns_map['مدين']=$col;
            if(str_contains($h_clean,'دائن'))  $columns_map['دائن']=$col;
        }

        foreach($columns_map as $k=>$v){
            if($v==='') $warnings[]="⚠️ لم أجد العمود: $k";
        }

        $defaultClient = "عميل افتراضي";

        foreach($rows as $row){
            $date   = safeTrim($columns_map['التاريخ']!=='' ? $row[$columns_map['التاريخ']] : '');
            $desc   = safeTrim($columns_map['البيان']!=='' ? $row[$columns_map['البيان']] : '');
            $debit  = safeTrim($columns_map['مدين']!=='' ? $row[$columns_map['مدين']] : '');
            $credit = safeTrim($columns_map['دائن']!=='' ? $row[$columns_map['دائن']] : '');
            $clients[$defaultClient][] = ['date'=>$date,'desc'=>$desc,'debit'=>$debit,'credit'=>$credit];
        }

        $_SESSION['clients'] = $clients;

    } catch(Exception $e){
        die("<div class='alert alert-danger'>❌ خطأ أثناء قراءة الملف: ".$e->getMessage()."</div>");
    }
}
?>

<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
<meta charset="UTF-8">
<title>رفع وتحليل Excel</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/crypto-js/4.1.1/crypto-js.min.js"></script>
</head>
<body class="container mt-4">

<h2 class="mb-4 text-center">📂 رفع ملف Excel وتحليل العميل</h2>

<form action="" method="post" enctype="multipart/form-data" class="mb-4">
    <input type="file" name="excel_file" accept=".xlsx,.xls" class="form-control mb-2" required>
    <button type="submit" class="btn btn-primary">رفع الملف</button>
</form>

<?php if(!empty($warnings)): ?>
    <div class="alert alert-warning">
        <?php foreach($warnings as $w) echo $w."<br>"; ?>
    </div>
<?php endif; ?>

<?php if(!empty($clients)): ?>
    <?php foreach($clients as $client=>$movements): ?>
        <h5><?= htmlspecialchars($client) ?></h5>
        <table class="table table-bordered table-striped mb-2">
            <thead class="table-dark">
                <tr>
                    <th>التاريخ</th>
                    <th>البيان</th>
                    <th>مدين</th>
                    <th>دائن</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach($movements as $m): ?>
                    <tr>
                        <td><?= htmlspecialchars($m['date']) ?></td>
                        <td><?= htmlspecialchars($m['desc']) ?></td>
                        <td><?= htmlspecialchars($m['debit']) ?></td>
                        <td><?= htmlspecialchars($m['credit']) ?></td>
                    </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
        <button class="btn btn-success mb-3 analyze-btn" data-client="<?= htmlspecialchars($client) ?>">ابدأ التحليل للعميل</button>
        <div class="analysis-result mb-4" id="result-<?= md5($client) ?>"></div>
    <?php endforeach; ?>
<?php endif; ?>

<script>
$(document).ready(function(){
    $('.analyze-btn').click(function(){
        var btn = $(this);
        var clientName = btn.data('client');
        var resultDiv = $('#result-' + CryptoJS.MD5(clientName));

        resultDiv.html("⏳ جاري التحليل...");

        $.post('analyze_gemini.php', {client: clientName}, function(data){
            resultDiv.html("<pre>"+data+"</pre>");
        });
    });
});
</script>

</body>
</html>
