<?php
include 'config.php';
$customers = $conn->query("SELECT * FROM customers ORDER BY name")->fetchAll(PDO::FETCH_ASSOC);
$products = $conn->query("SELECT * FROM products ORDER BY name")->fetchAll(PDO::FETCH_ASSOC);
?>
<!DOCTYPE html><html lang="ar"><head><meta charset="utf-8"><title>إنشاء وصل</title>
<style>body{font-family:Tahoma;direction:rtl;padding:15px} table{border-collapse:collapse;width:100%} th,td{border:1px solid #ccc;padding:6px;text-align:center} input,select{padding:6px;width:100%}</style>
<script>
function addRow(){ let t=document.getElementById('items'); let r=document.querySelector('.template').cloneNode(true); r.classList.remove('template'); r.style.display=''; t.appendChild(r); }
function removeRow(b){ b.closest('tr').remove(); calcGrand(); }
function updatePrice(sel){ let price = sel.options[sel.selectedIndex].getAttribute('data-price')||0; let tr=sel.closest('tr'); tr.querySelector('.unit_price').value=parseFloat(price).toFixed(2); calcRow(tr); }
function calcRow(tr){ let qty=parseFloat(tr.querySelector('.qty').value)||0; let price=parseFloat(tr.querySelector('.unit_price').value)||0; tr.querySelector('.total').value=(qty*price).toFixed(2); calcGrand(); }
function calcGrand(){ let tot=0; document.querySelectorAll('.total').forEach(i=>tot+=parseFloat(i.value||0)); document.getElementById('grand_show').innerText=tot.toFixed(2); document.getElementById('grand_total').value=tot.toFixed(2); }
</script>
</head><body>
<a href="index.php">← رجوع</a><h2>إنشاء وصل تسليم</h2>
<form method="post" action="save_delivery.php">
<label>اختار الزبون</label>
<select name="customer_id" required><option value="">-- اختر --</option>
<?php foreach($customers as $c): ?><option value="<?= $c['id'] ?>"><?= htmlspecialchars($c['code'].' - '.$c['name']) ?></option><?php endforeach; ?>
</select>

<h3>المواد</h3>
<table><thead><tr><th>المادة</th><th>السعر</th><th>الكمية</th><th>الإجمالي</th><th>إجراء</th></tr></thead><tbody id="items">
<tr>
<td><select name="product_id[]" onchange="updatePrice(this)" required><option value="">-- اختر --</option>
<?php foreach($products as $p): ?><option value="<?= $p['id'] ?>" data-price="<?= $p['unit_price'] ?>"><?= htmlspecialchars($p['name']) ?></option><?php endforeach; ?>
</select></td>
<td><input type="number" step="0.01" class="unit_price" name="unit_price[]" value="0" oninput="calcRow(this.closest('tr'))"></td>
<td><input type="number" class="qty" name="quantity[]" value="1" min="1" oninput="calcRow(this.closest('tr'))"></td>
<td><input type="text" class="total" name="item_total[]" value="0.00" readonly></td>
<td><button type="button" onclick="removeRow(this)">إزالة</button></td>
</tr>

<tr class="template" style="display:none">
<td><select name="product_id[]" onchange="updatePrice(this)" required><option value="">-- اختر --</option>
<?php foreach($products as $p): ?><option value="<?= $p['id'] ?>" data-price="<?= $p['unit_price'] ?>"><?= htmlspecialchars($p['name']) ?></option><?php endforeach; ?>
</select></td>
<td><input type="number" step="0.01" class="unit_price" name="unit_price[]" value="0" oninput="calcRow(this.closest('tr'))"></td>
<td><input type="number" class="qty" name="quantity[]" value="1" min="1" oninput="calcRow(this.closest('tr'))"></td>
<td><input type="text" class="total" name="item_total[]" value="0.00" readonly></td>
<td><button type="button" onclick="removeRow(this)">إزالة</button></td>
</tr>
</tbody></table>
<button type="button" onclick="addRow()">➕ إضافة مادة</button>
<h3>الإجمالي: <span id="grand_show">0.00</span></h3>
<input type="hidden" name="total" id="grand_total" value="0">
<button type="submit">حفظ و توليد PDF</button>
</form>
</body></html>
