<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

require 'config.php';
require __DIR__ . '/vendor/autoload.php';

use Mpdf\Mpdf;
use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;

// === تحقق من POST ===
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['manual_customer'])) {

    $customer_id = $_POST['manual_customer'];
    $product_ids = $_POST['product_id'] ?? [];
    $quantities  = $_POST['quantity'] ?? [];
    $units       = $_POST['unit'] ?? [];

    if (!$customer_id || empty($product_ids)) die("❌ يجب اختيار العميل وإضافة المنتجات");

    // جلب بيانات العميل
    $stmt = $conn->prepare("SELECT * FROM customers WHERE id=?");
    $stmt->execute([$customer_id]);
    $customer = $stmt->fetch(PDO::FETCH_ASSOC);
    if (!$customer) die("❌ لم يتم العثور على العميل.");

    // مجلد مؤقت للـ PDF
    $tmpDir = __DIR__ . '/tmp';
    if (!file_exists($tmpDir)) mkdir($tmpDir, 0777, true);

    $mpdf = new Mpdf([
        'format'=>'A5',
        'orientation'=>'L',
        'default_font'=>'dejavusans',
        'margin_top' => 30,
        'margin_bottom' => 15,
        'margin_left' => 15,
        'margin_right' => 15,
        'tempDir' => $tmpDir
    ]);

    $random_invoice = rand(1000,9999);
    $date = date('Y-m-d');

    if(!file_exists(__DIR__.'/invoices')) mkdir(__DIR__.'/invoices',0777,true);
    $pdf_file = __DIR__."/invoices/invoice_$random_invoice.pdf";

    $total_qty = 0;
    foreach($product_ids as $k=>$pid){
        $total_qty += $quantities[$k];
    }

    // === HTML الفاتورة ===
    $html = "
    <html lang='tr' dir='ltr'>
    <head>
    <meta charset='UTF-8'>
    <style>
        body { font-family: dejavusans; font-size: 11px; margin:0; padding:0; }
        .header { width:100%; overflow:hidden; margin-bottom:5px; }
        .header img { float:left; width:70px; height:auto; }
        .header .company-info { float:right; font-size:12px; line-height:1.1; text-align:right; }
        .customer-box { border:1px solid #333; padding:8px; margin-bottom:12px; font-size:14px; line-height:1.6; background:#f9f9f9; text-align:center; font-weight:bold; }
        .customer-box .details { font-size:13px; color:#000; }
        table.products { border-collapse: collapse; width: 100%; }
        table.products th, table.products td { border:1px solid #333; padding:5px; text-align:center; }
        table.products th { background-color:#f0f0f0; }
        .totals { text-align:right; margin-top:5px; font-weight:bold; }
        .signature { margin-top:15px; text-align:right; }
        h2 { text-align:center; margin:6px 0 10px 0; font-size:14px; }
    </style>
    </head>
    <body>

    <div class='header'>
        <img src='1.jpeg' style='width:90px; height:auto; display:block; float:left; margin:0; padding:0;'>
        <div class='company-info'>
            <strong>ALJAMEEL INTERNATIONAL GIDA SANAYI</strong><br>
            TEL: 05344438000 - 02124707700<br>
            ADRES: TURKEY- ISTANBUL-BASAKSEHIR<br>
            GIDA TOPTANCILER SETESI/3 ADA/2A/07_08
        </div>
        <div style='clear:both;'></div>
    </div>

    <h2>İRSALİYE</h2>

    <div class='customer-box'>
        <div><strong>MÜŞTERİ:</strong> " . htmlspecialchars($customer['name']) . " &nbsp;&nbsp;|&nbsp;&nbsp;
        <strong>ADRES:</strong> " . htmlspecialchars($customer['address']) . "</div>
        <div class='details'>
            " . (!empty($customer['phone']) ? "<strong>TELEFON:</strong> " . htmlspecialchars($customer['phone']) . " &nbsp;&nbsp;|&nbsp;&nbsp;" : "") . "
            <strong>TARİH:</strong> $date &nbsp;&nbsp;|&nbsp;&nbsp;
            <strong>İRSALİYE NO:</strong> $random_invoice
        </div>
    </div>

    <table class='products'>
        <tr>
            <th>Ürün Adı</th>
            <th>Birim</th>
            <th>Miktar</th>
            <th>Birim Fiyat</th>
            <th>Toplam Fiyat</th>
        </tr>";

    foreach($product_ids as $k=>$pid){
        $stmt = $conn->prepare("SELECT name FROM products WHERE id=?");
        $stmt->execute([$pid]);
        $p = $stmt->fetch(PDO::FETCH_ASSOC);

        $unit = $units[$k] ?? 'kg';
        $q = $quantities[$k] ?? 0;

        $price = 0;
        $subtotal = 0;

        $html .= "<tr>
            <td>{$p['name']}</td>
            <td>$unit</td>
            <td>$q</td>
            <td>$price</td>
            <td>$subtotal</td>
        </tr>";
    }

    $html .= "</table>";

    $html .= "<p class='totals'>Toplam Miktar: $total_qty</p>
              <p class='totals'>Toplam Tutar: 0 $</p>";

    $html .= "<p class='signature' style='text-align:left; font-size:12px; font-weight:bold;'>Teslim Alan: </p>
    </body>
    </html>";

    // === إنشاء PDF ===
    $mpdf->WriteHTML($html);
    $mpdf->Output($pdf_file,'F');

    // === إرسال البريد ===
    $mail = new PHPMailer(true);
    try {
        $mail->isSMTP();
        $mail->Host = 'deltaweb.agency';
        $mail->SMTPAuth = true;
        $mail->Username = 'dd@deltaweb.agency';
        $mail->Password = '6dHQOAFf#xU&.ySi';
        $mail->SMTPSecure = 'ssl';
        $mail->Port = 465;

        $mail->setFrom('dd@deltaweb.agency', 'وصل تسليم');
        $mail->addAddress('aljameel@print.epsonconnect.com', $customer['name']);

        $mail->CharSet = 'UTF-8';
        $mail->isHTML(true);

        $mail->Subject = 'وصل تسليم (الأسعار = 0)';
        $mail->Body    = 'مرحبًا، تم إنشاء وصل تسليم جديد مع أسعار صفرية. يرجى الاطلاع على المرفق.';

        $mail->addAttachment($pdf_file);

        $mail->send();
        echo "✅ تم إنشاء وإرسال وصل التسليم (أسعار صفرية) بنجاح!";
    } catch (Exception $e) {
        echo "❌ خطأ في إرسال البريد: " . $mail->ErrorInfo;
    }
}
