<?php
session_start();

// التحقق من تسجيل الدخول
if (!isset($_SESSION['logged_in']) || $_SESSION['logged_in'] !== true) {
    header("Location: login.php");
    exit;
}

require 'config.php';
require __DIR__ . '/vendor/autoload.php';
use Mpdf\Mpdf;

// استقبال بيانات النموذج
$name      = $_POST['name']      ?? '';
$amount    = $_POST['amount']    ?? '';
$reason    = $_POST['reason']    ?? '';
$serial    = $_POST['serial']    ?? '';
$todayDate = date("Y-m-d");

// التحقق من البيانات
if (empty($name) || empty($amount) || empty($reason) || empty($serial)) {
    die("❌ يرجى إدخال جميع البيانات المطلوبة");
}

// إنشاء ملف PDF
$mpdf = new Mpdf();
$html = "
<html>
<head>
    <style>
        body { font-family: DejaVu Sans, sans-serif; }
        .content { border: 1px solid #000; padding: 20px; }
        .title { font-size: 20px; font-weight: bold; text-align: center; margin-bottom: 20px; }
        .line { margin-bottom: 10px; }
    </style>
</head>
<body>
    <div class='content'>
        <div class='title'>وصل دفع</div>
        <div class='line'>الاسم: $name</div>
        <div class='line'>المبلغ: $amount</div>
        <div class='line'>السبب: $reason</div>
        <div class='line'>التسلسل: $serial</div>
        <div class='line'>التاريخ: $todayDate</div>
    </div>
</body>
</html>
";

$mpdf->WriteHTML($html);

// اسم الملف
$filename = "receipt_" . time() . ".pdf";

// عرض الملف في المتصفح
$mpdf->Output($filename, 'I');
exit;
