<?php
require 'config.php';
include 'navbar.php';

ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

require __DIR__ . '/vendor/autoload.php';
use PhpOffice\PhpSpreadsheet\IOFactory;

$msg = '';

// تحديث الحد الائتماني مباشرة
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['customer_name'], $_POST['new_credit'])) {
    $name = trim($_POST['customer_name']);
    $new_credit = trim($_POST['new_credit']);

    $new_credit_lower = mb_strtolower($new_credit, 'UTF-8');

    if ($new_credit === '') {
        $new_credit = 'لم يتم تحديد حد';
    } elseif ($new_credit_lower === 'مفتوح') {
        $new_credit = 'مفتوح';
    } elseif ($new_credit_lower === 'كاش') {
        $new_credit = 'كاش';
    } elseif (!is_numeric($new_credit)) {
        $new_credit = 'لم يتم تحديد حد';
    }

    $stmt = $conn->prepare("UPDATE customers SET credit_balance=? WHERE name=?");
    $stmt->execute([$new_credit, $name]);
    $msg = "✅ تم تحديث الحد الائتماني للعميل $name";
}

// رفع ملف الحد الائتماني
if (isset($_FILES['credit_file'])) {
    if ($_FILES['credit_file']['error'] === UPLOAD_ERR_OK) {
        $tmp = $_FILES['credit_file']['tmp_name'];
        try {
            $spreadsheet = IOFactory::load($tmp);
            $sheet = $spreadsheet->getActiveSheet();
            $rows = $sheet->toArray(null, true, true, true);
            $updateStmt = $conn->prepare("UPDATE customers SET credit_balance=? WHERE name=?");
            $updatedCount = 0;

            foreach ($rows as $row) {
                $name = trim($row['A'] ?? '');
                $credit = trim($row['B'] ?? '');
                if ($name === '') continue;

                $credit_lower = mb_strtolower($credit, 'UTF-8');

                if ($credit === '') {
                    $credit = 'لم يتم تحديد حد';
                } elseif ($credit_lower === 'مفتوح') {
                    $credit = 'مفتوح';
                } elseif ($credit_lower === 'كاش') {
                    $credit = 'كاش';
                } elseif (!is_numeric($credit)) {
                    $credit = 'لم يتم تحديد حد';
                }

                $updateStmt->execute([$credit, $name]);
                $updatedCount += $updateStmt->rowCount();
            }

            $msg = "✅ تم تحديث $updatedCount حد ائتماني بنجاح.";
        } catch (Exception $e) {
            $msg = "❌ خطأ: " . $e->getMessage();
        }
    } else {
        $msg = "❌ خطأ أثناء رفع الملف.";
    }
}

// الفلاتر والترتيب
$filter_rep = $_GET['representative'] ?? '';
$filter_status = $_GET['status'] ?? '';
$order_by = $_GET['order_by'] ?? 'balance';

// جلب العملاء
$sql = "SELECT name, balance, representative, credit_balance FROM customers WHERE 1";
$params = [];
if ($filter_rep !== '') {
    $sql .= " AND representative=?";
    $params[] = $filter_rep;
}
$sql .= $order_by === 'credit' ? " ORDER BY credit_balance DESC" : " ORDER BY balance DESC";

$stmt = $conn->prepare($sql);
$stmt->execute($params);
$customers = $stmt->fetchAll(PDO::FETCH_ASSOC);

// قائمة المندوبين
$reps = $conn->query("SELECT DISTINCT representative FROM customers WHERE representative IS NOT NULL AND representative != ''")->fetchAll(PDO::FETCH_COLUMN);
?>

<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
<meta charset="UTF-8">
<title>📊 متابعة المستحقات والحدود الائتمانية</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
<style>
.over-limit {background-color:#f8d7da !important; font-weight:bold;}
.within-limit {background-color:#d4edda !important;}
.no-limit {background-color:#fff3cd !important;}
.table td input {width:90px;}
</style>
</head>
<body class="container mt-4">

<h2 class="mb-4 text-center">📊 متابعة المستحقات والحدود الائتمانية</h2>

<?php if ($msg) echo "<div class='alert alert-info text-center'>$msg</div>"; ?>

<!-- رفع حد ائتماني -->
<div class="card mb-4">
  <div class="card-header bg-warning text-dark">⬆️ رفع حد ائتماني</div>
  <div class="card-body">
    <form method="post" enctype="multipart/form-data">
      <input type="file" name="credit_file" accept=".xlsx,.xls,.csv" class="form-control mb-2" required>
      <button type="submit" class="btn btn-warning">رفع وتحديث الحد الائتماني</button>
    </form>
    <small class="text-muted">📄 العمود A: اسم العميل — العمود B: الحد الائتماني (رقم أو كلمة "مفتوح" أو "كاش")</small>
  </div>
</div>

<!-- خيارات التصفية -->
<form method="get" class="row mb-3 g-2">
  <div class="col-md-3">
    <select name="representative" class="form-select">
      <option value="">كل المندوبين</option>
      <?php foreach ($reps as $rep): ?>
      <option value="<?= htmlspecialchars($rep) ?>" <?= $filter_rep === $rep ? 'selected' : '' ?>><?= htmlspecialchars($rep) ?></option>
      <?php endforeach; ?>
    </select>
  </div>
  <div class="col-md-3">
    <select name="status" class="form-select">
      <option value="">كل العملاء</option>
      <option value="over" <?= $filter_status==='over'?'selected':''?>>تجاوز الحد</option>
      <option value="within" <?= $filter_status==='within'?'selected':''?>>ضمن الحد</option>
      <option value="open" <?= $filter_status==='open'?'selected':''?>>حساب مفتوح</option>
      <option value="undefined" <?= $filter_status==='undefined'?'selected':''?>>لم يتم تحديد حد</option>
    </select>
  </div>
  <div class="col-md-3">
    <select name="order_by" class="form-select">
      <option value="balance" <?= $order_by==='balance'?'selected':''?>>ترتيب حسب الرصيد</option>
      <option value="credit" <?= $order_by==='credit'?'selected':''?>>ترتيب حسب الحد الائتماني</option>
    </select>
  </div>
  <div class="col-md-3">
    <button type="submit" class="btn btn-primary w-100">تطبيق</button>
  </div>
</form>

<!-- جدول العملاء -->
<div class="card">
<div class="card-body p-0">
<table class="table table-bordered table-striped m-0 text-center">
<thead class="table-dark">
<tr>
<th>الاسم</th>
<th>الرصيد</th>
<th>المندوب</th>
<th>الحد الائتماني</th>
<th>تحديث الحد</th>
<th>الحالة</th>
</tr>
</thead>
<tbody>
<?php
if (empty($customers)) {
    echo "<tr><td colspan='6'>⚠️ لا توجد بيانات</td></tr>";
} else {
    foreach ($customers as $c) {
        $balance = floatval($c['balance']);
$credit_raw = trim($c['credit_balance'] ?? '');
        $status = '';
        $row_class = '';

        $credit_lower = mb_strtolower($credit_raw, 'UTF-8');

        if ($credit_lower == 'مفتوح') {
            $status = '✅ حساب مفتوح';
            $row_class = 'no-limit';
        } elseif ($credit_lower == 'كاش') {
            $credit_value = 0;
            $status = ($balance > $credit_value) ? '❌ تجاوز الحد' : '✅ ضمن الحد';
            $row_class = ($balance > $credit_value) ? 'over-limit' : 'within-limit';
        } elseif ($credit_raw === '' || !is_numeric($credit_raw)) {
            $status = '⚠️ لم يتم تحديد حد';
            $row_class = 'no-limit';
        } elseif (is_numeric($credit_raw)) {
            $credit_value = floatval($credit_raw);
            $status = ($balance > $credit_value) ? '❌ تجاوز الحد' : '✅ ضمن الحد';
            $row_class = ($balance > $credit_value) ? 'over-limit' : 'within-limit';
        }

        // تطبيق الفلترة
        if ($filter_status==='over' && $status!=='❌ تجاوز الحد') continue;
        if ($filter_status==='within' && $status!=='✅ ضمن الحد') continue;
        if ($filter_status==='open' && $status!=='✅ حساب مفتوح') continue;
        if ($filter_status==='undefined' && $status!=='⚠️ لم يتم تحديد حد') continue;
?>
<tr class="<?= $row_class ?>">
<td><?= htmlspecialchars($c['name']) ?></td>
<td><?= number_format($balance,2) ?></td>
<td><?= htmlspecialchars($c['representative']) ?></td>
<td><?= htmlspecialchars($credit_raw) ?></td>
<td>
<form method="post" class="d-flex justify-content-center gap-1">
<input type="text" name="new_credit" value="<?= htmlspecialchars($credit_raw) ?>" class="form-control form-control-sm" placeholder="رقم أو مفتوح أو كاش">
<input type="hidden" name="customer_name" value="<?= htmlspecialchars($c['name']) ?>">
<button type="submit" class="btn btn-sm btn-success">💾 حفظ</button>
</form>
</td>
<td><?= $status ?></td>
</tr>
<?php } } ?>
</tbody>
</table>
</div>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
