<?php
require 'config.php';
require __DIR__ . '/vendor/autoload.php'; // مكتبة mPDF

use Mpdf\Mpdf;

// التحقق من البيانات
if ($_SERVER['REQUEST_METHOD'] !== 'POST' || empty($_POST['customer_id']) || empty($_POST['product_id'])) {
    die("❌ البيانات غير مكتملة");
}

$customer_id = intval($_POST['customer_id']);

// جلب بيانات العميل
$stmt = $conn->prepare("SELECT * FROM customers WHERE id=?");
$stmt->execute([$customer_id]);
$customer = $stmt->fetch(PDO::FETCH_ASSOC);
if (!$customer) die("❌ العميل غير موجود");

// إدخال الوصل
$conn->beginTransaction();
try {
    $stmt = $conn->prepare("INSERT INTO deliveries (customer_id, total) VALUES (?, ?)");
    $stmt->execute([$customer_id, 0]);
    $delivery_id = $conn->lastInsertId();

    $total = 0;
    $items_html = "";

    foreach ($_POST['product_id'] as $i => $product_id) {
        $product_id = intval($product_id);
        $quantity = floatval($_POST['quantity'][$i]);
        $price = floatval($_POST['price'][$i]);
        $subtotal = $quantity * $price;
        $total += $subtotal;

        // حفظ تفاصيل الوصل
        $stmt = $conn->prepare("INSERT INTO delivery_items (delivery_id, product_id, quantity, price) VALUES (?, ?, ?, ?)");
        $stmt->execute([$delivery_id, $product_id, $quantity, $price]);

        // جلب اسم المادة والوحدة
        $stmt2 = $conn->prepare("SELECT name, unit FROM products WHERE id=?");
        $stmt2->execute([$product_id]);
        $prod = $stmt2->fetch(PDO::FETCH_ASSOC);

        $items_html .= "
        <tr>
            <td>{$prod['name']}</td>
            <td>{$quantity} {$prod['unit']}</td>
            <td>{$price}</td>
            <td>{$subtotal}</td>
        </tr>";
    }

    // تحديث الإجمالي
    $stmt = $conn->prepare("UPDATE deliveries SET total=? WHERE id=?");
    $stmt->execute([$total, $delivery_id]);

    $conn->commit();
} catch (Exception $e) {
    $conn->rollBack();
    die("❌ خطأ: " . $e->getMessage());
}

// توليد PDF
$mpdf = new Mpdf(['format' => 'A5-L']);

$html = "
<style>
body { font-family: DejaVu Sans, sans-serif; font-size: 12px; }
.header { text-align:right; }
table { width:100%; border-collapse: collapse; margin-top: 10px; }
th, td { border:1px solid #000; padding:5px; text-align:center; }
</style>

<div class='header'>
    <img src='logo.png' style='width:80px; float:left;'>
    <h2>شركة دلتا ويب</h2>
    <p>العنوان: اسطنبول - تركيا<br>
    الهاتف: +90 555 555 55 55<br>
    البريد: info@deltaweb.agency</p>
</div>

<hr>

<h3>وصل تسليم رقم #{$delivery_id}</h3>
<p>
<strong>العميل:</strong> {$customer['name']} <br>
<strong>العنوان:</strong> {$customer['address']} <br>
<strong>الهاتف:</strong> {$customer['phone']}
</p>

<table>
    <thead>
        <tr>
            <th>المادة</th>
            <th>الكمية</th>
            <th>السعر الفردي</th>
            <th>الإجمالي</th>
        </tr>
    </thead>
    <tbody>
        $items_html
    </tbody>
</table>

<h3 style='text-align:left'>الإجمالي الكلي: {$total} $</h3>
<br><br>
<p>التوقيع: ________________</p>
";

// حفظ PDF في السيرفر
$filename = "delivery_{$delivery_id}.pdf";
$pdf_path = $PDF_DIR . "/" . $filename;
$mpdf->WriteHTML($html);
$mpdf->Output($pdf_path, 'F'); // نسخة على السيرفر
$mpdf->Output($filename, 'I'); // عرض PDF في المتصفح
?>
