<?php
require 'config.php';
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

require __DIR__ . '/vendor/autoload.php';
use PhpOffice\PhpSpreadsheet\IOFactory;

$msg = '';
$updated = 0;
$skipped = 0;

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_FILES['excel_file'])) {
    $tmp = $_FILES['excel_file']['tmp_name'];

    if ($_FILES['excel_file']['error'] !== UPLOAD_ERR_OK) {
        $msg = "❌ حصل خطأ أثناء رفع الملف.";
    } else {
        try {
            $spreadsheet = IOFactory::load($tmp);
            $sheet = $spreadsheet->getActiveSheet();
            $rows = $sheet->toArray(null, true, true, true);

            $updateStmt = $conn->prepare("UPDATE customers SET credit_balance=? WHERE name=?");

            foreach ($rows as $row) {
                $name = isset($row['A']) ? trim($row['A']) : '';
                $credit = isset($row['B']) ? floatval($row['B']) : 0;

                if ($name === '') continue;

                $updateStmt->execute([$credit, $name]);
                if ($updateStmt->rowCount() > 0) {
                    $updated++;
                } else {
                    $skipped++;
                }
            }

            $msg = "✅ تم تحديث $updated عميل. تم تخطي $skipped أسماء غير موجودة.";

        } catch (\PhpOffice\PhpSpreadsheet\Reader\Exception $e) {
            $msg = "❌ خطأ قراءة الملف: " . $e->getMessage();
        } catch (Exception $e) {
            $msg = "❌ خطأ: " . $e->getMessage();
        }
    }
}
?>

<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
<meta charset="UTF-8">
<title>تحديث الرصيد الائتماني</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="container mt-4">
<!-- القائمة العلوية -->
<nav class="navbar navbar-expand-lg navbar-dark bg-dark mb-4">
  <div class="container-fluid">
    <a class="navbar-brand" href="index.php">🏠 الرئيسية</a>
    <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNav">
        <span class="navbar-toggler-icon"></span>
    </button>
    <div class="collapse navbar-collapse" id="navbarNav">
      <ul class="navbar-nav">
        <li class="nav-item"><a class="nav-link" href="customers.php">العملاء</a></li>
        <li class="nav-item"><a class="nav-link" href="new_customer.php">إضافة عميل</a></li>
        <li class="nav-item"><a class="nav-link" href="products.php">المنتجات</a></li>
  
        <li class="nav-item"><a class="nav-link" href="upload_customers.php">رفع عملاء</a></li>
        <li class="nav-item"><a class="nav-link" href="upload_products.php">رفع مواد</a></li>
        <li class="nav-item"><a class="nav-link" href="receivables.php">المستحقات والارصدة</a></li>
        <li class="nav-item"><a class="nav-link" href="update_credit.php
">رفع رصيد ائتماني</a></li>
        <li class="nav-item"><a class="nav-link" href="logout.php">تسجيل الخروج</a></li>
      </ul>
    </div>
  </div>
</nav>

<h2 class="mb-4 text-center">تحديث الرصيد الائتماني للعملاء</h2>

<?php if ($msg): ?>
    <div class="alert alert-info text-center"><?= htmlspecialchars($msg) ?></div>
<?php endif; ?>

<div class="card p-4">
    <form method="post" enctype="multipart/form-data">
        <div class="mb-3">
            <label class="form-label">اختر ملف Excel (.xlsx, .xls, .csv)</label>
            <input type="file" name="excel_file" accept=".xlsx,.xls,.csv" class="form-control" required>
        </div>
        <p class="text-muted">العمود A: اسم العميل<br> العمود B: الرصيد الائتماني</p>
        <button type="submit" class="btn btn-success">تحديث الرصيد</button>
    </form>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
