<?php
session_start();
include 'navbar.php';
// كلمة السر لتسجيل الدخول
$PASSWORD = "522522"; 
if(isset($_POST['password'])){
    if($_POST['password'] === $PASSWORD){
        $_SESSION['logged_in'] = true;
    } else {
        $error = "كلمة السر غير صحيحة";
    }
}

if(!isset($_SESSION['logged_in'])){
    echo '<!DOCTYPE html>
    <html lang="ar" dir="rtl">
    <head><meta charset="UTF-8"><title>دخول</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    </head>
    <body class="container mt-5">
        <form method="post" style="max-width:400px; margin:auto;">
            <h3 class="mb-3">أدخل كلمة السر</h3>
            <input type="password" name="password" class="form-control mb-2" placeholder="كلمة السر" required>
            <button type="submit" class="btn btn-primary w-100">دخول</button>';
    if(!empty($error)) echo "<p style=\"color:red;\">$error</p>";
    echo '</form></body></html>';
    exit;
}

require 'config.php';
require __DIR__ . '/vendor/autoload.php';
use PhpOffice\PhpSpreadsheet\IOFactory;

$message = "";

// رفع الملف ومعالجة العملاء
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_FILES['file'])) {
    $file = $_FILES['file']['tmp_name'];
    $added = 0;
    $updated = 0;
    $unchanged = 0;

    try {
        $spreadsheet = IOFactory::load($file);
        $sheet = $spreadsheet->getActiveSheet();
        
        foreach ($sheet->getRowIterator() as $rowIndex => $row) {
            if ($rowIndex == 1) continue; // تخطي رأس الجدول

            $name = trim($sheet->getCell("A{$rowIndex}")->getValue());
            $balance = floatval($sheet->getCell("B{$rowIndex}")->getValue());
            $address = trim($sheet->getCell("C{$rowIndex}")->getValue());
            $phone = trim($sheet->getCell("D{$rowIndex}")->getValue());
            if (!$name) continue;

            // قراءة اللون من العمود A
            $fill = strtoupper($sheet->getStyle("A{$rowIndex}")->getFill()->getStartColor()->getRGB());

            // تحديد المندوب حسب اللون
            $representative = "غير محدد";
            switch ($fill) {
                case "C0C0FF":
                    $representative = "محمد";
                    break;
                case "00FFFF":
                    $representative = "دجوار";
                    break;
                case "FF0000":
                    $representative = "زبائن مجمدة";
                    break;
                case "A8FD53":
                    $representative = "أحمد";
                    break;
            }

            // تحقق إذا العميل موجود
            $stmt = $conn->prepare("SELECT * FROM customers WHERE name = ?");
            $stmt->execute([$name]);
            $existing = $stmt->fetch(PDO::FETCH_ASSOC);

            if ($existing) {
                if ($existing['balance'] != $balance || $existing['address'] != $address || $existing['phone'] != $phone || $existing['representative'] != $representative) {
                    $update = $conn->prepare("UPDATE customers SET balance=?, address=?, phone=?, representative=? WHERE id=?");
                    $update->execute([$balance, $address, $phone, $representative, $existing['id']]);
                    $updated++;
                } else {
                    $unchanged++;
                }
                $customerId = $existing['id'];
            } else {
                $insert = $conn->prepare("INSERT INTO customers (name, balance, address, phone, representative) VALUES (?, ?, ?, ?, ?)");
                $insert->execute([$name, $balance, $address, $phone, $representative]);
                $added++;
                $customerId = $conn->lastInsertId();
            }

            // سجل الرصيد بالتاريخ
            $record_date = date('Y-m-d');
            $historyInsert = $conn->prepare("INSERT INTO balance_history (customer_id, balance, record_date) VALUES (?, ?, ?)");
            $historyInsert->execute([$customerId, $balance, $record_date]);
        }

        $message = "✅ تم إضافة $added عميل جديد، تم تحديث $updated عميل، $unchanged عميل لم تتغير بياناته.";
    } catch (Exception $e) {
        $message = "❌ خطأ في قراءة الملف: " . $e->getMessage();
    }
}
?>

<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
<meta charset="UTF-8">
<title>رفع واستيراد العملاء</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body>

<

<div class="container">
<h2 class="mb-4 text-center">⬆️ رفع واستيراد العملاء من Excel</h2>

<?php if($message) echo "<div class='alert alert-info'>$message</div>"; ?>

<div class="alert alert-secondary">
    <strong>ملاحظة:</strong> يجب أن يكون شكل ملف Excel كالتالي: <br>
    <code>name | balance | address | phone</code> <br>
    (الألوان في العمود A تحدد المندوب تلقائيًا)
</div>

<form method="post" enctype="multipart/form-data" class="mb-4">
    <div class="mb-3">
        <label class="form-label">اختر ملف Excel (.xlsx)</label>
        <input type="file" name="file" class="form-control" accept=".xlsx" required>
    </div>
    <button type="submit" class="btn btn-success">رفع واستيراد العملاء</button>
</form>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
