<?php
include 'navbar.php';
// upload_products.php
// رفع ملف Excel يحتوي على أسماء المواد (عمود واحد: اسم المادة)
// يستخدم config.php للاتصال بقاعدة البيانات (تأكد أن config.php يعّرف $conn)

ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

require 'config.php';                 // يجب أن يحتوي على PDO $conn
require __DIR__ . '/vendor/autoload.php';
use PhpOffice\PhpSpreadsheet\IOFactory;

$message = "";
$inserted = 0;
$skipped = 0;
$deleted_old = false;

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_FILES['excel_file'])) {
    // خيار حذف المواد القديمة
    $truncate = isset($_POST['truncate']) && $_POST['truncate'] === '1';

    // تحقق من رفع الملف بنجاح
    if ($_FILES['excel_file']['error'] !== UPLOAD_ERR_OK) {
        $message = "❌ حصل خطأ أثناء رفع الملف.";
    } else {
        $tmp = $_FILES['excel_file']['tmp_name'];

        try {
            // إذا طلب المستخدم تفريغ الجدول قبل إضافة المواد
            if ($truncate) {
                // تحذير: إذا كان جدول products مرتبطاً بمفاتيح أجنبية (foreign keys)
                // قد يفشل الحذف أو يترك مراجع معطلة. تأكد قبل الاستخدام.
                $conn->exec("DELETE FROM products");
                // إعادة ضبط AUTO_INCREMENT
                $conn->exec("ALTER TABLE products AUTO_INCREMENT = 1");
                $deleted_old = true;
            }

            $spreadsheet = IOFactory::load($tmp);
            $sheet = $spreadsheet->getActiveSheet();
            $rows = $sheet->toArray(null, true, true, true); // نستخدم مفاتيح عمودية A,B,...

            // تحضير الاستعلامات
            $checkStmt = $conn->prepare("SELECT id FROM products WHERE name = ? LIMIT 1");
            $insertStmt = $conn->prepare("INSERT INTO products (name) VALUES (?)");

            foreach ($rows as $rindex => $row) {
                // نأخذ العمود A كاسم المادة
                $name = "";
                if (isset($row['A'])) $name = trim($row['A']);
                elseif (isset($row[0])) $name = trim($row[0]); // fallback

                if ($name === "") continue; // تجاهل الصفوف الفارغة

                // تحقق من التكرار (باسم مطابق تمامًا)
                $checkStmt->execute([$name]);
                $exists = $checkStmt->fetch(PDO::FETCH_ASSOC);
                if ($exists) {
                    $skipped++;
                    continue;
                }

                // إدراج
                $insertStmt->execute([$name]);
                $inserted++;
            }

            $message = "✅ انتهى: تم إدراج $inserted مادة. تم تخطي $skipped مادة مكررة.";
            if ($deleted_old) $message = "✅ جُدّد الجدول. " . $message;
        } catch (\PhpOffice\PhpSpreadsheet\Reader\Exception $e) {
            $message = "❌ خطأ قراءة الملف: " . $e->getMessage();
        } catch (Exception $e) {
            $message = "❌ خطأ: " . $e->getMessage();
        }
    }
}
?>
<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
<meta charset="utf-8">
<title>رفع المواد - Alj</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
<meta name="robots" content="noindex, nofollow">
</head>
<body class="container mt-4">
   

    <h3>رفع ملف المواد (Excel)</h3>

    <?php if($message): ?>
        <div class="alert alert-info"><?= htmlspecialchars($message) ?></div>
    <?php endif; ?>

    <div class="card p-3 mb-3">
        <form method="post" enctype="multipart/form-data">
            <div class="mb-3">
                <label class="form-label">اختر ملف Excel (.xlsx أو .xls أو .csv)</label>
                <input type="file" name="excel_file" accept=".xlsx,.xls,.csv" class="form-control" required>
            </div>

            <div class="form-check mb-3">
                <input class="form-check-input" type="checkbox" name="truncate" value="1" id="truncate">
                <label class="form-check-label" for="truncate">
                    مسح المواد القديمة قبل الإضافة (احذر إذا كانت هناك مراجع في جداول أخرى)
                </label>
            </div>

            <button type="submit" class="btn btn-success">رفع واستيراد المواد</button>
        </form>
    </div>

    <p class="text-muted">ملاحظة: الملف يجب أن يحتوي في العمود الأول (A) على أسماء المواد فقط. الصف الأول يمكن أن يكون عنواناً (سيتم التعامل معه كاسم إذا لم يكن فارغاً).</p>
    <a href="index.php" class="btn btn-secondary">العودة</a>
</body>
</html>
