<?php
include 'includes/functions.php';

// تعديل شركة
if(isset($_POST['edit_company'])){
    $stmt = $pdo->prepare("UPDATE companies SET username=?, alici_adi=?, alici_adresi=?, teslim_sekli=?, vergi_dairesi=?, vergi_numarasi=? WHERE id=?");
    $stmt->execute([
        $_POST['username'],
        $_POST['alici_adi'],
        $_POST['alici_adresi'],
        $_POST['teslim_sekli'],
        $_POST['vergi_dairesi'],
        $_POST['vergi_numarasi'],
        $_POST['id']
    ]);
    $msg = "تم تحديث بيانات الشركة بنجاح.";
}

// حذف شركة
if(isset($_POST['delete_company'])){
    $stmt = $pdo->prepare("DELETE FROM companies WHERE id=?");
    $stmt->execute([$_POST['id']]);
    $msg = "تم حذف الشركة بنجاح.";
}

// جلب الشركات
$companies = $pdo->query("SELECT * FROM companies ORDER BY id DESC")->fetchAll();
?>

<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
<meta charset="UTF-8">
<title>الشركات</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
<style>
body {
    background-color: #f9fafb;
    font-family: 'Cairo', sans-serif;
}
.table-container {
    background: #fff;
    border-radius: 15px;
    box-shadow: 0 6px 15px rgba(0,0,0,0.08);
    padding: 20px;
}
h3 {
    font-weight: 700;
    color: #0d6efd;
}
.table thead th {
    background-color: #0d6efd !important;
    color: #fff;
    font-weight: 600;
    text-align: center;
}
.table td {
    vertical-align: middle;
    background-color: #fcfcfc;
}
.table tr:hover td {
    background-color: #eef4ff;
}
.actions {
    display: flex;
    justify-content: center;
    gap: 6px;
}
input.editable {
    display: none;
    width: 100%;
    border: 1px solid #ccc;
    border-radius: 6px;
    padding: 5px;
}
span.view {
    display: block;
}
.save-btn {
    display: none;
}
.btn {
    border-radius: 8px;
}
</style>
</head>
<body>

<?php include 'includes/navbar.php'; ?>

<div class="container mt-4">
    <div class="table-container">
        <h3 class="mb-3 text-center">الشركات</h3>

        <?php if(isset($msg)) echo "<div class='alert alert-success text-center'>$msg</div>"; ?>

        <table class="table table-bordered table-striped align-middle text-center">
            <thead>
                <tr>
                    <th>اسم المستخدم</th>
                    <th>الاسم</th>
                    <th>العنوان</th>
                    <th>طريقة التسليم</th>
                    <th>دائرة الضريبة</th>
                    <th>الرقم الضريبي</th>
                    <th>الخيارات</th>
                </tr>
            </thead>
            <tbody>
            <?php if(!$companies): ?>
                <tr><td colspan="7" class="text-muted">لا توجد شركات مضافة بعد</td></tr>
            <?php else: ?>
            <?php foreach($companies as $c): ?>
                <tr>
                    <form method="POST" class="company-form">
                    <td>
                        <span class="view"><?= htmlspecialchars($c['username']) ?></span>
                        <input type="text" name="username" value="<?= htmlspecialchars($c['username']) ?>" class="editable">
                    </td>
                    <td>
                        <span class="view"><?= htmlspecialchars($c['alici_adi']) ?></span>
                        <input type="text" name="alici_adi" value="<?= htmlspecialchars($c['alici_adi']) ?>" class="editable">
                    </td>
                    <td>
                        <span class="view"><?= htmlspecialchars($c['alici_adresi']) ?></span>
                        <input type="text" name="alici_adresi" value="<?= htmlspecialchars($c['alici_adresi']) ?>" class="editable">
                    </td>
                    <td>
                        <span class="view"><?= htmlspecialchars($c['teslim_sekli']) ?></span>
                        <input type="text" name="teslim_sekli" value="<?= htmlspecialchars($c['teslim_sekli']) ?>" class="editable">
                    </td>
                    <td>
                        <span class="view"><?= htmlspecialchars($c['vergi_dairesi']) ?></span>
                        <input type="text" name="vergi_dairesi" value="<?= htmlspecialchars($c['vergi_dairesi']) ?>" class="editable">
                    </td>
                    <td>
                        <span class="view"><?= htmlspecialchars($c['vergi_numarasi']) ?></span>
                        <input type="text" name="vergi_numarasi" value="<?= htmlspecialchars($c['vergi_numarasi']) ?>" class="editable">
                    </td>
                    <td class="actions">
                        <input type="hidden" name="id" value="<?= $c['id'] ?>">
                        <button type="button" class="btn btn-warning btn-sm edit-btn">تعديل</button>
                        <button type="submit" name="edit_company" class="btn btn-success btn-sm save-btn">حفظ</button>
                        <button type="submit" name="delete_company" class="btn btn-danger btn-sm" onclick="return confirm('هل أنت متأكد من الحذف؟')">حذف</button>
                        <a href="invoices_list.php?company_id=<?= $c['id'] ?>" class="btn btn-info btn-sm">فواتير</a>
                    </td>
                    </form>
                </tr>
            <?php endforeach; ?>
            <?php endif; ?>
            </tbody>
        </table>
    </div>
</div>

<script>
document.querySelectorAll('.edit-btn').forEach(btn=>{
    btn.addEventListener('click', ()=>{
        const row = btn.closest('tr');
        row.querySelectorAll('span.view').forEach(s=>s.style.display='none');
        row.querySelectorAll('input.editable').forEach(i=>i.style.display='block');
        btn.style.display='none';
        row.querySelector('.save-btn').style.display='inline-block';
    });
});
</script>

</body>
</html>
