<?php
include 'includes/functions.php';

// تأكد من تمرير company_id
if(!isset($_GET['company_id']) || empty($_GET['company_id'])){
    die("لم يتم تحديد الشركة.");
}

$company_id = (int)$_GET['company_id'];

// جلب بيانات الشركة
$stmt = $pdo->prepare("SELECT * FROM companies WHERE id=?");
$stmt->execute([$company_id]);
$company = $stmt->fetch();
if(!$company){
    die("الشركة غير موجودة.");
}

// فلاتر الفواتير
$filter_product = $_GET['product'] ?? '';
$filter_currency = $_GET['currency'] ?? '';
$filter_date_from = $_GET['date_from'] ?? '';
$filter_date_to = $_GET['date_to'] ?? '';

$where = ["invoices.company_id = ?"];
$params = [$company_id];

if($filter_product){
    $where[] = "invoice_items.product_id = ?";
    $params[] = $filter_product;
}
if($filter_currency){
    $where[] = "invoices.currency = ?";
    $params[] = $filter_currency;
}
if($filter_date_from){
    $where[] = "invoices.created_at >= ?";
    $params[] = $filter_date_from . ' 00:00:00';
}
if($filter_date_to){
    $where[] = "invoices.created_at <= ?";
    $params[] = $filter_date_to . ' 23:59:59';
}

$join_product = $filter_product ? "JOIN invoice_items ON invoices.id = invoice_items.invoice_id" : "";
$where_sql = "WHERE ".implode(" AND ", $where);

$sql = "SELECT DISTINCT invoices.* 
        FROM invoices
        $join_product
        $where_sql
        ORDER BY invoices.id DESC";

$stmt = $pdo->prepare($sql);
$stmt->execute($params);
$invoices = $stmt->fetchAll();

// مجموع الفواتير بعد الفلاتر
$total_sum = 0;
foreach($invoices as $inv){
    $total_sum += $inv['total'];
}

// جلب المنتجات للعملاء الفلاتر
$products = $pdo->query("SELECT * FROM products")->fetchAll();
$currencies = ['TL'=>'ليرة تركية','USD'=>'دولار'];
?>

<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
<meta charset="UTF-8">
<title>فواتير <?= htmlspecialchars($company['alici_adi']) ?></title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
<style>
.table thead th { background-color: #0d6efd; color: #fff; text-align: center; }
.table td { vertical-align: middle; text-align: center; }
.total-box { background: #f0f0f0; padding: 12px; margin-bottom: 15px; border-radius: 5px; font-weight: bold; }
</style>
</head>
<body>
<?php include 'includes/navbar.php'; ?>
<div class="container py-4">
<h3 class="mb-4 text-primary">فواتير <?= htmlspecialchars($company['alici_adi']) ?></h3>

<!-- بيانات الشركة -->
<div class="card mb-3">
    <div class="card-body">
        <p><strong>الاسم:</strong> <?= htmlspecialchars($company['alici_adi']) ?></p>
        <p><strong>العنوان:</strong> <?= htmlspecialchars($company['alici_adresi']) ?></p>
        <p><strong>طريقة التسليم:</strong> <?= htmlspecialchars($company['teslim_sekli']) ?></p>
        <p><strong>دائرة الضريبة:</strong> <?= htmlspecialchars($company['vergi_dairesi']) ?></p>
        <p><strong>الرقم الضريبي:</strong> <?= htmlspecialchars($company['vergi_numarasi']) ?></p>
    </div>
</div>

<!-- المجموع الإجمالي -->
<div class="total-box">
إجمالي الفواتير بعد الفلاتر: <?= number_format($total_sum,2) ?>
</div>

<!-- نموذج الفلاتر -->
<form method="GET" class="row g-3 mb-4">
    <input type="hidden" name="company_id" value="<?= $company_id ?>">
    <div class="col-md-3">
        <label>المادة</label>
        <select name="product" class="form-select">
            <option value="">الكل</option>
            <?php foreach($products as $p): ?>
            <option value="<?= $p['id'] ?>" <?= $filter_product==$p['id']?'selected':'' ?>><?= htmlspecialchars($p['name']) ?></option>
            <?php endforeach; ?>
        </select>
    </div>
    <div class="col-md-2">
        <label>العملة</label>
        <select name="currency" class="form-select">
            <option value="">الكل</option>
            <?php foreach($currencies as $k=>$v): ?>
            <option value="<?= $k ?>" <?= $filter_currency==$k?'selected':'' ?>><?= $v ?></option>
            <?php endforeach; ?>
        </select>
    </div>
    <div class="col-md-2">
        <label>من تاريخ</label>
        <input type="date" name="date_from" value="<?= $filter_date_from ?>" class="form-control">
    </div>
    <div class="col-md-2">
        <label>إلى تاريخ</label>
        <input type="date" name="date_to" value="<?= $filter_date_to ?>" class="form-control">
    </div>
    <div class="col-md-3 d-flex align-items-end gap-2">
        <button class="btn btn-primary">تطبيق الفلاتر</button>
        <a href="invoices_list.php?company_id=<?= $company_id ?>" class="btn btn-secondary">مسح الفلاتر</a>
    </div>
</form>

<!-- جدول الفواتير -->
<!-- جدول الفواتير -->
<table class="table table-bordered table-striped">
<tr>
    <th>رقم الفاتورة</th>
    <th>الإجمالي</th>
    <th>العملة</th>
    <th>تاريخ الإنشاء</th>
    <th>إجراءات</th>
</tr>
<?php if($invoices): ?>
<?php foreach($invoices as $inv):
    $file = "invoices/invoice_".$inv['id'].".pdf";
?>
<tr>
<td><?= $inv['id'] ?></td>
<td><?= number_format($inv['total'],2) ?></td>
<td><?= $inv['currency'] ?></td>
<td><?= $inv['created_at'] ?></td>
<td>
    <a class="btn btn-warning btn-sm" href="invoice_edit.php?invoice_id=<?= $inv['id'] ?>">✏️ تعديل</a>
    <a class="btn btn-success btn-sm" href="<?= $file ?>" target="_blank">عرض</a>
    <a class="btn btn-primary btn-sm" href="<?= $file ?>" download>تنزيل</a>
    <a class="btn btn-info btn-sm" href="https://api.whatsapp.com/send?phone=+90<?= '5342009435' ?>&text=رابط%20الفاتورة%20<?= urlencode('https://deltaweb.agency/invoice-system/'.$file) ?>" target="_blank">واتساب</a>
</td>
</tr>
<?php endforeach; ?>
<?php else: ?>
<tr><td colspan="5" class="text-center text-muted">لا توجد فواتير حسب الفلاتر المحددة</td></tr>
<?php endif; ?>
</table>

</div>
</body>
</html>
