<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

require_once __DIR__ . '/vendor/autoload.php';
use Mpdf\Mpdf;

function generateInvoicePDF($invoice_id, $company, $invoice_items, $total, $currency = 'TL') {
    $folder = __DIR__ . '/invoices';
    if (!file_exists($folder)) mkdir($folder, 0777, true);

    $file = $folder . "/invoice_$invoice_id.pdf";

    $mpdf = new Mpdf([
        'mode' => 'utf-8',
        'format' => 'A4-L',
        'tempDir' => __DIR__ . '/tmp',
        'default_font' => 'dejavusans'
    ]);

    // حماية المفاتيح من الغياب
    $company['alici_adi'] = $company['alici_adi'] ?? '';
    $company['alici_adresi'] = $company['alici_adresi'] ?? '';
    $company['teslim_sekli'] = $company['teslim_sekli'] ?? '';
    $company['vergi_dairesi'] = $company['vergi_dairesi'] ?? '';
    $company['vergi_numarasi'] = $company['vergi_numarasi'] ?? '';

    $urunNames = [];
    $urunMiktar = [];
    $urunFiyat = [];
    foreach ($invoice_items as $item) {
        $urunNames[] = $item['name'];
        $urunMiktar[] = $item['name'] . ':' . $item['quantity'];
        $urunFiyat[] = $item['name'] . ':' . $item['price'] . ' ' . $currency;
    }

    $miktar_text = implode(' ', $urunMiktar);
    $birimfiyat_text = implode(' ', $urunFiyat);
    $geneltutar_text = $total . ' ' . $currency;

    $html = '
    <table border="1" cellpadding="6" cellspacing="0" style="border-collapse: collapse; width: 100%; font-family: dejavusans;">
        <tr style="background-color: #3399FF; text-align: center; font-weight: bold; font-size: 14pt; color: #ffffff;">
            <td colspan="2" style="text-align: center;">
YURTIÇİ FATURASI / DOMESTIC INVOICE /فاتورة داخلية 
</td>
        </tr>
        <tr style="background-color: #E6E6E6;"><td style="width: 25%; font-weight: bold;">ALICI ADI</td><td>'.$company['alici_adi'].'</td></tr>
        <tr style="background-color: #E6E6E6;"><td style="font-weight: bold;">ALICI ADRESI</td><td>'.$company['alici_adresi'].'</td></tr>
        <tr style="background-color: #E6E6E6;"><td style="font-weight: bold;">URUN AÇIKLAMASI</td><td>'.implode(', ', $urunNames).'</td></tr>
        <tr style="background-color: #E6E6E6;"><td style="font-weight: bold;">MIKTAR</td><td>'.$miktar_text.'</td></tr>
        <tr style="background-color: #E6E6E6;"><td style="font-weight: bold;">BIRIM</td><td>KG</td></tr>
        <tr style="background-color: #E6E6E6;"><td style="font-weight: bold;">BIRIM FIYAT</td><td>'.$birimfiyat_text.'</td></tr>
        <tr style="background-color: #E6E6E6;"><td style="font-weight: bold;">GENEL TUTAR</td><td>'.$geneltutar_text.'</td></tr>
        <tr style="background-color: #E6E6E6;"><td style="font-weight: bold;">TESLIM ŞEKLI</td><td>'.$company['teslim_sekli'].'</td></tr>
        <tr style="background-color: #E6E6E6;"><td style="font-weight: bold;">VERGI DAIRESI</td><td>'.$company['vergi_dairesi'].'</td></tr>
        <tr style="background-color: #E6E6E6;"><td style="font-weight: bold;">VERGI NUMARASI</td><td>'.$company['vergi_numarasi'].'</td></tr>
    </table>
    ';

    $mpdf->WriteHTML($html);
    $mpdf->Output($file, \Mpdf\Output\Destination::FILE);

    return 'invoices/invoice_'.$invoice_id.'.pdf';
}
?>
